% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program ContrastModulatedGrating.m
c = 0.50;
f = 1/32;
[x,  y] = meshgrid(-64:63,  64:-1:-63);
N = 2*(rand(128,128) > 0.5) - 1;
M = uint8(127*(1 + N.*(0.5 + c*sin(2.0*pi*f*x))));
showImage(M, 'grayscale'); 
